// IBView.cpp : CIBView NX̓̒`s܂B
//

#include "stdafx.h"
#include "IB.h"

#include "IBDoc.h"
#include "IBView.h"
#include "IBPreView.h"
#include "ChildFrm.h"
#include "SpeechInputDlg.h"
#include "InteractionToolView.h"
#include "AgentOutputDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CStatusBar *g_pStBar;
extern CInteractionToolView *pIToolView;
/////////////////////////////////////////////////////////////////////////////
// CIBView

//for TEST
int nNest;

IMPLEMENT_DYNCREATE(CIBView, CScrollView)

BEGIN_MESSAGE_MAP(CIBView, CScrollView)
	//{{AFX_MSG_MAP(CIBView)
	ON_WM_SIZE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
	// WR}h
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIBView NX̍\z/

CIBView::CIBView()
{
	// TODO: ̏ꏊɍ\zp̃R[hǉĂB
	m_strPath = "";
	m_pSelectedItem = NULL;
	bWViewActive = FALSE;
	bWViewSChange = FALSE;
	nIsTABLE = 0;
	nTDLeft = 0;
	nTDTop = 0;
	nTDHeight = 0;
	nTDWidth = 0;
	strDIVid = "";

	nviewSizeX = 0;
	nviewSizeY = 0;

	nObjIndex = 0;
	bPluralSelect = FALSE;
}

CIBView::~CIBView()
{
	m_ObjList.RemoveAll();
}

BOOL CIBView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB
	CSize sizeTotal;
	// TODO: ̃r[̃TCY̍vvZ܂B
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);

	return CScrollView::PreCreateWindow(cs);
}


/////////////////////////////////////////////////////////////////////////////
// CIBView NX̃\bh

/******************************************************************************************
 ֐		: BOOL CIBView::AnalyzeHTML(LPDISPATCH pDisp)
 @\		: HTML͂ăXgɓo^
 		: pDisp --------- ͂HTML̃fBXpb`|C^
 ߂l		: int ----------
 쐬		: @TH
 쐬		: 2001/10/27
 ******************************************************************************************/
int CIBView::AnalyzeHTML(LPDISPATCH pDisp)
{
	HRESULT hr = S_OK;

	try
	{
		//IHTMLDocument2C^tF[X̍쐬
		MSHTML::IHTMLDocument2Ptr spHTMLDoc;
		hr = pDisp->QueryInterface(MSHTML::IID_IHTMLDocument2,(void**)&spHTMLDoc);
		if(hr != S_OK){ throw -1; } //IHTMLDocment2̍쐬s

		//^O͑SłH
		MSHTML::IHTMLElementCollectionPtr spColElement;
		spHTMLDoc->get_all(&spColElement);
		if(hr != S_OK){ throw -2; } //Svf̎擾s
		long lAllLen = 0;
		spColElement->get_length(&lAllLen);
		TRACE("ALL: %d\n",lAllLen);

		//擪̗vfIDispatchC^tF[X擾
		LPDISPATCH pNodeDisp = NULL;
		pNodeDisp = spColElement->item(_variant_t(long(0)),_variant_t(long(0)));

		//IHTMLDOMNode𐶐
		MSHTML::IHTMLDOMNodePtr spHTMLNode;
		hr = pNodeDisp->QueryInterface(MSHTML::IID_IHTMLDOMNode,(void**)&spHTMLNode);
		if(hr != S_OK){ throw -3; } //IHTMLDOMNode̐s


		//HTMLIuWFNgXgɒǉ
		nNest = 0;	//for TEST

		ClearMember();

		TEXTOBJ_FONT textFont;
		textFont.bBold = FALSE;
		textFont.bItalic = FALSE;
		textFont.nPoint = 12;
		textFont.strFontType = "lr pSVbN";
		textFont.eAlign = LEFT;
		textFont.textColor = 0x000000;

		OBJ_STYLE objStyle;
		objStyle.bgcolor = 0xffffff;
		objStyle.bgimage = "";
		objStyle.eAlign = LEFT;

		AnalyzeElement(spHTMLNode,0,0,textFont,objStyle);
	}
	catch(int nCode)
	{
		char *pMsg;
		switch(nCode)
		{
		case -1 : {pMsg = "AnalyzeHTML :: Can't Creat IHTMLDocument!!";break;}
		case -2 : {pMsg = "AnalyzeHTML :: Can't Get IHTMLElementCollection!!";break;}
		case -3 : {pMsg = "AnalyzeHTML :: Can't Creat IHTMLDOMNode!!";break;}
		default : {pMsg = "AnalyzeHTML :: Unknown error code!"; break; }
		}
		//afxDump << pMsg << "\n";
		return nCode;
	}

	OnUpdate(this,NULL,NULL);
	return 0;
}


/******************************************************************************************
 ֐		: int CIBView::AnalyzeElement(MSHTML::IHTMLDOMNodePtr spHTMLNode,
							  long lLeft, long lTop, TEXTOBJ_FONT textFont, OBJ_STYLE objStyle)
 @\		: ċAIɃGg
 		: spHTMLNode@͂m[h
			@lLeft,lTop  e̕\ʒu
			  textFont    ẽtHgX^C
			  objStyle    ẽIuWFNgX^C
 ߂l		: int ----------
 ******************************************************************************************/
int CIBView::AnalyzeElement(MSHTML::IHTMLDOMNodePtr spHTMLNode,
							  long lLeft, long lTop, TEXTOBJ_FONT textFont, OBJ_STYLE objStyle)
{
	HRESULT hr = S_OK;
	try
	{
		CString strTagName;
		while(spHTMLNode)
		{
			/*for TEST
			for(int n=0; n<nNest; n++)
				TRACE("  ");
			TRACE("  |---");
			//*/

			//m[hvfȂ
			if(spHTMLNode->nodeType == 1)
			{
				AnalyzeAttribute(spHTMLNode,&textFont,&objStyle);

				//IHTMLElement
				MSHTML::IHTMLElementPtr spHTMLElem;
				hr = spHTMLNode->QueryInterface(MSHTML::IID_IHTMLElement,(void**)&spHTMLElem);
		//		hr = pNodeDisp->QueryInterface(MSHTML::IID_IHTMLElement,(void**)&spHTMLElem);
				if(hr != S_OK){ throw -4; } //IHTMLElement̐s

				//vf̃^O擾
				BSTR bstrTagName = NULL;
				hr = spHTMLElem->get_tagName(&bstrTagName);
				strTagName = bstrTagName;
				if(hr != S_OK){ throw -5; } //^O̎擾s
				SysFreeString(bstrTagName);
				
				/* for TEST
				TRACE("<%7s> ::",(LPCTSTR)strTagName);
				//*/

				//vfid擾
				BSTR bstrTagID = NULL;
				hr = spHTMLElem->get_id(&bstrTagID);
				if(hr != S_OK){ throw -6; } //idl̎擾s
				CString strID = bstrTagID;
				if(strID.IsEmpty())
					strID = "NONE";
				/*
				else
				{
					int i=0;
					while(i!=-1)
					{
						i = strID.Find("=",i);
						if(i!=-1)
						{
							strID.Insert(i+1,"\"");
							i = strID.Find("]",i);
							strID.Insert(i,"\"");
						}
					}
				}*/
				SysFreeString(bstrTagID);

				/*for TEST
				TRACE("id=\"%s \"",(LPCTSTR)strID);
				SysFreeString(bstrTagID);
				//*/

				
				//vf̍WʒuCTCY擾
				long lTempLeft=0,lTempTop=0,lTempHeight=0,lTempWidth=0;
				spHTMLElem->get_offsetLeft(&lTempLeft);
				spHTMLElem->get_offsetTop(&lTempTop);
				spHTMLElem->get_offsetHeight(&lTempHeight);
				spHTMLElem->get_offsetWidth(&lTempWidth);
				
				//r[̍őTCY𔻒
				if(nviewSizeX < (lTempWidth+lTempLeft))
					nviewSizeX = lTempWidth+lTempLeft;
				if(nviewSizeY < (lTempHeight+lTempTop))
					nviewSizeY = lTempHeight+lTempTop;

				//<DIV>id̓L[v
				if(strTagName.CompareNoCase("DIV") == 0)
				{
					strDIVid = strID;
				}
				//TABLEҏW?
				if(strTagName.CompareNoCase("TABLE") == 0)
				{
					//TABLEҏWȂCe̕\ʒu̒lɂ
					if(nIsTABLE>0)
					{
						lLeft = nTDLeft + lTempLeft;
						lTop = nTDTop + lTempTop;
					}
					else
					{
						lLeft = lTempLeft;
						lTop = lTempTop;
					}
					nIsTABLE++;
				}
				//<TD>or<TH>̃TCYޔ
				if(strTagName.CompareNoCase("TD") == 0
					|| strTagName.CompareNoCase("TH") == 0)
				{
					nTDLeft = lLeft + lTempLeft;
					nTDTop = lTop + lTempTop;
					nTDHeight = lTempHeight;
					nTDWidth = lTempWidth;

					CTableObj *pTableObj = new CTableObj;
					pTableObj->SetRect(nTDLeft,nTDTop,nTDHeight,nTDWidth);

					//vfstyle擾
					AnalyzeStyle(spHTMLElem,&textFont,&objStyle);

					pTableObj->m_ObjStyle = objStyle;
					pTableObj->SetXMLPath(strID);
					pTableObj->nIndex = nObjIndex;

					m_ObjList.AddTail(pTableObj);
					nObjIndex++;

					strDIVid = strID;
				}

				//<IMG>^O̓o^
				if(strTagName.CompareNoCase("IMG") == 0)
				{
					if(!RegistIMGObj(spHTMLElem,strID,lTempLeft,lTempTop,lTempHeight,lTempWidth))
					{throw -9;}  //C[WIuWFNg̓o^s
				}

				//<INPUT>^O̓o^
				if(strTagName.CompareNoCase("INPUT") == 0)
				{
					if(!RegistInputObj(spHTMLElem,strID,lTempLeft,lTempTop,lTempHeight,lTempWidth))
					{throw -10;} //InputIuWFNg̓o^s
				}

				//tHgw蒆H
				if(strTagName.CompareNoCase("FONT") == 0)
				{
					VARIANT vAttr = spHTMLElem->getAttribute(_bstr_t(L"face"),0);
					BSTR bstrAttr = V_BSTR(&vAttr);
					if(bstrAttr)
						textFont.strFontType = bstrAttr;
					SysFreeString(bstrAttr);

					vAttr = spHTMLElem->getAttribute(_bstr_t(L"size"),0);
					bstrAttr = V_BSTR(&vAttr);
					if(bstrAttr)
						textFont.nPoint = (atoi(CString(bstrAttr)) - 3)*2 + 12;
					SysFreeString(bstrAttr);

					vAttr = spHTMLElem->getAttribute(_bstr_t(L"color"),0);
					bstrAttr = V_BSTR(&vAttr);
					if(bstrAttr)
						textFont.textColor = HexToInt(CString(bstrAttr));
					SysFreeString(bstrAttr);
				}
				if(strTagName.CompareNoCase("B") == 0)
					textFont.bBold = TRUE;
				if(strTagName.CompareNoCase("I") == 0)
					textFont.bItalic = TRUE;

				/*for TEST
				TRACE("(left:%3d, Top:%3d, Height:%3d, Width:%3d)",lTempLeft,lTempTop,lTempHeight,lTempWidth);
				//*/

				//vfstyle擾
				AnalyzeStyle(spHTMLElem,&textFont,&objStyle);
				
				ReleaseObj(spHTMLElem);
			}
			//m[heLXgȂ
			else if(spHTMLNode->nodeType == 3)
			{
				if(!RegistTextObj(spHTMLNode,textFont)){throw -8;} //eLXgIuWFNg̓o^s
			}

			/*for TEST
			MSHTML::IHTMLDOMNodePtr spParentNode;
			BSTR bstrParent = NULL;
			spHTMLNode->get_parentNode(&spParentNode);
			spParentNode->get_nodeName(&bstrParent);
			CString strBuff = bstrParent;
			TRACE("(<%6s>)",(LPCTSTR)strBuff);
			SysFreeString(bstrParent);
			//*/

			//*for TEST
			TRACE("\n");
			nNest++;
			//*/

			//q̃m[hȂ
			if(spHTMLNode->hasChildNodes())
			{
				LPDISPATCH pChildrenDisp = NULL;
				MSHTML::IHTMLDOMChildrenCollectionPtr spColChildren;
				spHTMLNode->get_childNodes(&pChildrenDisp);
				hr = pChildrenDisp->QueryInterface(MSHTML::IID_IHTMLDOMChildrenCollection,(void**)&spColChildren);
				if(hr != S_OK){ throw -7; } //qvfXg̎擾s
				pChildrenDisp->Release();pChildrenDisp = NULL;

				long lChildLen;
				spColChildren->get_length(&lChildLen);
				
				for(long i=0; i<lChildLen; i++)
				{
					MSHTML::IHTMLDOMNodePtr spChildNode;
					spChildNode = spColChildren->item(i);

					AnalyzeElement(spChildNode,lLeft,lTop,textFont,objStyle);
				}
				ReleaseObj(spColChildren);
			}
			//TABLEҏWI
			if(strTagName.CompareNoCase("TABLE") == 0)
				nIsTABLE--;

			ReleaseObj(spHTMLNode);
		}
	}
	catch(int nCode)
	{
		char *pMsg;
		switch(nCode)
		{
		case -4 : {pMsg = "RegistElement :: Can't Creat IHTMLElement!!";break;}
		case -5 : {pMsg = "RegistElement :: Can't Get TagName!!";break;}
		case -6 : {pMsg = "RegistElement :: Can't Get TagID!!";break;}
		case -7 : {pMsg = "RegistElement :: Can't Creat IHTMLDOMChildrenCollection!!";break;}
		case -8 : {pMsg = "RegistElement :: Can't Regist TextObj!!";break;}
		default : {pMsg = "RegistElement :: Unknown error code!"; break; }
		}
		//afxDump << pMsg << "\n";
		return nCode;
	}

	nNest--;	//for TEST
	return 0;
}


/******************************************************************************************
 ֐		: int CIBView::AnalyzeAttribute(MSHTML::IHTMLDOMNodePtr spAttrNode,
							   TEXTOBJ_FONT *textFont,OBJ_STYLE *objStyle)
 @\		: 
 		: spAttrNode@͂m[h
			  textFont    Ώۂ̃tHgX^C
			  objStyle    Ώۂ̃IuWFNgX^C
 ߂l		: int ----------
 ******************************************************************************************/
int CIBView::AnalyzeAttribute(MSHTML::IHTMLDOMNodePtr spAttrNode,
							   TEXTOBJ_FONT *textFont,OBJ_STYLE *objStyle)
{
	HRESULT hr = S_OK;

	LPDISPATCH pDisp;
	MSHTML::IHTMLDOMAttributePtr spDOMAttr;
	MSHTML::IHTMLAttributeCollection2Ptr spColAttr;
	//pDisp = spHTMLNode->attributes;
	hr = spAttrNode->get_attributes(&pDisp);
	hr = pDisp->QueryInterface(MSHTML::IID_IHTMLAttributeCollection2,(void**)&spColAttr);
				
	CString strAttr;
	VARIANT_BOOL vSpecified = VARIANT_TRUE;
	BSTR bstrAttr;
	//ALIGÑ`FbN
	bstrAttr = SysAllocString(L"align");
	spDOMAttr = spColAttr->getNamedItem(bstrAttr);
	if(spDOMAttr)
	{
		vSpecified = spDOMAttr->Getspecified();
		if(vSpecified)
		{
			VARIANT vValue;
			spDOMAttr->get_nodeValue(&vValue);
			strAttr = V_BSTR(&vValue);
			if(strAttr.CompareNoCase("LEFT") == 0)
				textFont->eAlign = LEFT;
			else if(strAttr.CompareNoCase("CENTER") == 0)
				textFont->eAlign = CENTER;
			else if(strAttr.CompareNoCase("RIGHT") == 0)
				textFont->eAlign = RIGHT;
			VariantClear(&vValue);
		}
	}
	SysFreeString(bstrAttr);
	ReleaseObj(spDOMAttr);

	//BGCOLOR̃`FbN
	bstrAttr = SysAllocString(L"bgcolor");
	spDOMAttr = spColAttr->getNamedItem(bstrAttr);
	if(spDOMAttr)
	{
		vSpecified = spDOMAttr->Getspecified();
		if(vSpecified)
		{
			VARIANT vValue;
			spDOMAttr->get_nodeValue(&vValue);
			strAttr = V_BSTR(&vValue);
			objStyle->bgcolor = HexToInt(strAttr);
			VariantClear(&vValue);
		}
	}
	SysFreeString(bstrAttr);
	ReleaseObj(spDOMAttr);
	
	ReleaseObj(spColAttr);

	return 0;
}


/******************************************************************************************
 ֐		: int CIBView::AnalyzeStyle(MSHTML::IHTMLElementPtr spHTMLElement,TEXTOBJ_FONT *textFont, OBJ_STYLE *objStyle)
 @\		: Style
 		: spHTMLNode@͂m[h
			  textFont    Ώۂ̃tHgX^C
			  objStyle    Ώۂ̃IuWFNgX^C
 ߂l		: int ----------
 ******************************************************************************************/
int CIBView::AnalyzeStyle(MSHTML::IHTMLElementPtr spHTMLElement,TEXTOBJ_FONT *textFont, OBJ_STYLE *objStyle)
{
	HRESULT hr = S_OK;
	try
	{
		MSHTML::IHTMLStylePtr spStyle;
		hr = spHTMLElement->get_style(&spStyle);
		if(hr != S_OK){ throw -9; } //IHTMLstyle̐s

		VARIANT vBGColor;
		spStyle->get_backgroundColor(&vBGColor);
		CString strColor = V_BSTR(&vBGColor);
		if(!strColor.IsEmpty())
			objStyle->bgcolor = HexToInt(strColor);
		VariantClear(&vBGColor);

		BSTR bstrFontFamily;
		spStyle->get_fontFamily(&bstrFontFamily);
		if(bstrFontFamily)
			textFont->strFontType = bstrFontFamily;
		SysFreeString(bstrFontFamily);

		VARIANT vSize;
		spStyle->get_fontSize(&vSize);
		CString strSize = V_BSTR(&vSize);
		if(!strSize.IsEmpty())
		{
			int nPt;
			CString strUnit = strSize.Right(2);
			if(strUnit.Compare("px") == 0)
				nPt = atoi(strSize)*72/96;
			else
				nPt = atoi(strSize);
			textFont->nPoint = nPt;
		}
		VariantClear(&vSize);

		VARIANT vColor;
		spStyle->get_color(&vColor);
		strColor = V_BSTR(&vColor);
		if(!strColor.IsEmpty())
			textFont->textColor = HexToInt(strColor);
		VariantClear(&vColor);

		BSTR bstrAlign;
		spStyle->get_textAlign(&bstrAlign);
		CString strAlign = bstrAlign;
		if(strAlign.CompareNoCase("LEFT") == 0)
			textFont->eAlign = LEFT;
		else if(strAlign.CompareNoCase("CENTER") == 0)
			textFont->eAlign = CENTER;
		else if(strAlign.CompareNoCase("RIGHT") == 0)
			textFont->eAlign = RIGHT;
		SysFreeString(bstrAlign);
	}
	catch(int nCode)
	{
		char *pMsg;
		switch(nCode)
		{
		case -9 : {pMsg = "RegistStyle :: Can't Creat IHTMLStyle!!";break;}
		default : {pMsg = "RegistElement :: Unknown error code!"; break; }
		}
		//afxDump << pMsg << "\n";
		return nCode;
	}

	return 0;
}


/******************************************************************************************
 ֐		: BOOL CIBView::RegistTextObj(MSHTML::IHTMLDOMNodePtr spHTMLNode)
 @\		: eLXgIuWFNgXgɓo^
 		: spHTMLNode --------- o^m[h
 ߂l		: BOOL ----------
 쐬		: @TH
 쐬		: 2001/11/8
 ******************************************************************************************/
BOOL CIBView::RegistTextObj(MSHTML::IHTMLDOMNodePtr spHTMLNode,TEXTOBJ_FONT textFont)
{
	VARIANT vNodeValue;
	spHTMLNode->get_nodeValue(&vNodeValue);
	CString strTagValue = V_BSTR(&vNodeValue);

	//󔒂͖̕܂
	strTagValue.Remove(' ');
	if(!strTagValue.IsEmpty())
	{
		MSHTML::IHTMLElementPtr spHTMLElem;
		MSHTML::IHTMLDOMNodePtr spPreviousNode;
		MSHTML::IHTMLDOMNodePtr spParentNode;
		spHTMLNode->get_previousSibling(&spPreviousNode);
		spHTMLNode->get_parentNode(&spParentNode);

		//Zm[hΐem[h
		if(spPreviousNode)
			spPreviousNode->QueryInterface(MSHTML::IID_IHTMLElement,(void**)&spHTMLElem);
		else
			spParentNode->QueryInterface(MSHTML::IID_IHTMLElement,(void**)&spHTMLElem);

		long lTempTop, lTempLeft,lTempHeight,lTempWidth;
		spHTMLElem->get_offsetLeft(&lTempLeft);
		spHTMLElem->get_offsetTop(&lTempTop);
		spHTMLElem->get_offsetHeight(&lTempHeight);
		spHTMLElem->get_offsetWidth(&lTempWidth);

		//vf̃^O擾
		BSTR bstrTagName = NULL;
		HRESULT hr;
		hr = spHTMLElem->get_tagName(&bstrTagName);
		CString strParent = bstrTagName;
		if(hr != S_OK) //^O̎擾s
			return FALSE;
		SysFreeString(bstrTagName);
		//s^ȌꍇTopȊO͐e^O̒lKp
		if(strParent.CompareNoCase("BR") == 0)
		{
			MSHTML::IHTMLElementPtr spParentElem;
			spHTMLElem->get_parentElement(&spParentElem);
			spParentElem->get_offsetLeft(&lTempLeft);
			lTempTop += lTempHeight;
			spParentElem->get_offsetHeight(&lTempHeight);
			spParentElem->get_offsetWidth(&lTempWidth);
			ReleaseObj(spParentElem);
		}

		//eLXgIuWFNg𐶐
		CTextObj *pTextObj = new CTextObj;
		//l
		pTextObj->strText = V_BSTR(&vNodeValue);
		//TABLEҏWTABLE܂ł̒lǉ
		if(nIsTABLE>0)
		{
			int nLeft, nTop;
			if(spPreviousNode == NULL && strParent.CompareNoCase("TD") == 0)
			{
				nLeft = nTDLeft;
				nTop = nTDTop;
			}
			else
			{
				nLeft = nTDLeft+lTempLeft;
				nTop = nTDTop+lTempTop;
			}
			pTextObj->SetRect(nLeft,nTop,lTempHeight,lTempWidth);
			TRACE("[%s]",(LPCTSTR)strTagValue);
			TRACE("(left:%3d, Top:%3d, Height:%3d, Width:%3d)",nLeft,nTop,lTempHeight,lTempWidth);
		}
		else
		{
			pTextObj->SetRect(lTempLeft,lTempTop,lTempHeight,lTempWidth);
			TRACE("[%s]",(LPCTSTR)strTagValue);
			TRACE("(left:%3d, Top:%3d, Height:%3d, Width:%3d)",lTempLeft,lTempTop,lTempHeight,lTempWidth);
		}
		
		//<DIV>idZbg
		pTextObj->SetXMLPath(strDIVid);

		pTextObj->m_Font = textFont;
		pTextObj->nIndex = nObjIndex;
		//IuWFNg̐JEgCXgɒǉ
		m_ObjList.AddTail(pTextObj);
		nObjIndex++;
		
		ReleaseObj(spHTMLElem);
		ReleaseObj(spPreviousNode);
		ReleaseObj(spParentNode);
	}
	return TRUE;
}


/******************************************************************************************
 ֐		: BOOL CIBView::RegistIMGObj(IHTMLElementPtr spIMGElem)
 @\		: IMGIuWFNgXgɓo^
 		: spIMGElem --------- o^<IMG>Gg
 ߂l		: BOOL ----------
 쐬		: @TH
 쐬		: 2001/11/9
 ******************************************************************************************/
BOOL CIBView::RegistIMGObj(MSHTML::IHTMLElementPtr spIMGElem,LPCTSTR lpszXMLPath,
						   int nLeft,int nTop,int nHeight,int nWidth)
{
	//e[uҏW<TD>gɕ\
	if(nIsTABLE>0)
	{
		nLeft += nTDLeft;
		nTop += nTDTop;
	}

	CString strIMGPath;
	VARIANT vAttr = spIMGElem->getAttribute(_bstr_t(L"SRC"),0);
	BSTR bstrAttr = V_BSTR(&vAttr);
	if(bstrAttr)
		strIMGPath = bstrAttr;
	else
		strIMGPath = "";
	SysFreeString(bstrAttr);
	VariantClear(&vAttr);

	//C[WIuWFNg̐
	CImgObj *pImgObj = new CImgObj;
	strIMGPath.Delete(0,8);
	//摜̎荞
	pImgObj->Load(strIMGPath);
	//Ήwlk̃pXo^
	pImgObj->SetXMLPath(lpszXMLPath);
	//TCYo^
	pImgObj->SetRect(nLeft,nTop,nHeight,nWidth);
	pImgObj->nIndex = nObjIndex;

	m_ObjList.AddTail(pImgObj);
	nObjIndex++;
	return TRUE;
}


/******************************************************************************************
 ֐		: BOOL CIBView::RegistInputObj(MSHTML::IHTMLElementPtr spInputElem, LPCTSTR lpszXMLPath,
							 int nLeft, int nTop, int nHeight, int nWidth)
 @\		: InputIuWFNgXgɓo^
 		: spInputElem --------- o^<INPUT>Gg
			  lpszXMLPath --------- ΉXML̃pX
 ߂l		: BOOL ----------
 ******************************************************************************************/
BOOL CIBView::RegistInputObj(MSHTML::IHTMLElementPtr spInputElem, LPCTSTR lpszXMLPath,
							 int nLeft, int nTop, int nHeight, int nWidth)
{
	//e[uҏW<TD>gɕ\
	if(nIsTABLE>0)
	{
		nLeft += nTDLeft;
		nTop += nTDTop;
	}

	CString strInputTyp;
	VARIANT vAttr = spInputElem->getAttribute(_bstr_t(L"type"),0);
	strInputTyp = V_BSTR(&vAttr);
	VariantClear(&vAttr);

	CString strCaption;
	vAttr = spInputElem->getAttribute(_bstr_t(L"value"),0);
	strCaption = V_BSTR(&vAttr);
	VariantClear(&vAttr);

	//{^̓o^
	if(strInputTyp.CompareNoCase("button") == 0)
	{
		CButtonObj *pButtonObj = new CButtonObj;
		//݂̃XN[|WVɍ킹
		CPoint point = GetScrollPosition();

		pButtonObj->SetXMLPath(lpszXMLPath);
		pButtonObj->SetRect(nLeft-point.x,nTop-point.y,nHeight,nWidth);
		pButtonObj->nIndex = nObjIndex;

		//{^Rg[̐
		if(!pButtonObj->CreateObj(strCaption,this))
			return FALSE;

		m_ObjList.AddTail(pButtonObj);
		nObjIndex++;
	}
	else if(strInputTyp.CompareNoCase("text") == 0)
	{
		CTextEditObj *pTextEdtitObj = new CTextEditObj;
		//݂̃XN[|WVɍ킹
		CPoint point = GetScrollPosition();

		pTextEdtitObj->SetXMLPath(lpszXMLPath);
		pTextEdtitObj->SetRect(nLeft-point.x,nTop-point.y,nHeight,nWidth);
		pTextEdtitObj->nIndex = nObjIndex;

		if(!pTextEdtitObj->CreateObj(this))
			return FALSE;

		m_ObjList.AddTail(pTextEdtitObj);
		nObjIndex++;
	}

	return TRUE;
}



int CIBView::HexToInt(CString &str)
{ /* PUi𐔒l */
	int a,i,r;
	a=1; /* ZΏۂƂȂ錅́ud݁v */
	r=0; /*  */

	//RGB->BGRɕϊ
	CString strColor = "";
	strColor += str.Right(2);
	strColor += str.Mid(3,2);
	strColor += str.Mid(1,2);

	for (i=5;i>-1;i--) { /* ꎚÂo */
		switch (strColor[i])
		{ /* ꎚo̐lZ */
		case '0':
			r+=a*0;
			break;
		case '1':
            r+=a*1;
			break;
		case '2':
			r+=a*2;
			break;
		case '3':
			r+=a*3;
			break;
		case '4':
			r+=a*4;
			break;
		case '5':
			r+=a*5;
			break;
		case '6':
			r+=a*6;
			break;
		case '7':
			r+=a*7;
			break;
		case '8':
			r+=a*8;
			break;
		case '9':
			r+=a*9;
			break;
		case 'a':
			r+=a*10;
			break;
		case 'b':
			r+=a*11;
			break;
		case 'c':
			r+=a*12;
			break;
		case 'd':
			r+=a*13;
			break;
		case 'e':
			r+=a*14;
			break;
		case 'f':
			r+=a*15;
			break;
		}
		a*=16; /* ̌́ud݁v߂ */
	}
	return r; /* ʂ̐lԂ */
}


void CIBView::ClearMember()
{
	nIsTABLE = 0;
	nObjIndex = 0;
	nTDHeight = 0;
	nTDLeft = 0;
	nTDTop = 0;
	nTDWidth = 0;

	nviewSizeX = 0;
	nviewSizeY = 0;

	strDIVid = "";

	m_ObjList.RemoveAll();
}


/******************************************************************************************
 ֐		: BOOL CIBView::FindObjItem(POINT point, CObjItem **pObjItem)
 @\		: w肵|Cgɑ݂IuWFNg
 		: point --------- w肵|Cg
			  pObjItem --------- IuWFNgi[|C^
 ߂l		: BOOL ----------
 ******************************************************************************************/
BOOL CIBView::FindObjItem(POINT point, CObjItem **pObjItem)
{
	int nLen = m_ObjList.GetLength();
	CRect rect;
	CObjItem *pObj;

	for(int i=nLen-1; i>0; i--)
	{
		pObj = m_ObjList.GetItem(i);
		pObj->GetRect(&rect);
		rect.NormalizeRect();
		if(rect.PtInRect(point))
		{
			CString strPath = pObj->GetXMLPath();
			if(!strPath.IsEmpty())
			{
				*pObjItem = pObj;
				return TRUE;
			}
		}
	}
	pObjItem = NULL;
	return FALSE;
}

/******************************************************************************************
 ֐		: BOOL CIBView::SelectedItem(CObjItem *pObjItem)
 @\		: w肵IuWFNgIԂɂ
 		: pObjItem --------- IIuWFNg
 ߂l		: BOOL ----------
 ******************************************************************************************/
void CIBView::SetSelectedItem(CObjItem *pObjItem,BOOL bPlural)
{
	CObjItem *pItem;
	bPluralSelect = bPlural;
	for(int i=0; i<nObjIndex; i++)
	{
		pItem = m_ObjList.GetItem(i);
		if(bPlural && pObjItem)
		{
			if(pItem->IsBrother(pObjItem->GetXMLPath()))
				pItem->bSelect = TRUE;
			else
				pItem->bSelect = FALSE;
		}
		else
			pItem->bSelect = FALSE;
	}

	CString strPath;
	if(pObjItem)
	{
		g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_FORM),"Not Form");
		strPath = pObjItem->GetXMLPath();
		if(strPath.Compare("NONE") != 0)
		{
			pObjItem->bSelect = TRUE;
			m_pSelectedItem = pObjItem;
			m_strPath = strPath;
			pIToolView->NotifySelect(m_strPath);
			if(pObjItem->GetObjType() == IDW_OBJ_EDIT)
			{
				CIBDoc *pDoc = GetDocument();
				//Xe[^Xo[ɕ\
				g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_FORM),strPath);
				pIToolView->NotifySelectForm(m_strPath,pDoc->GetPathName());
			}
		}
		else
		{
			pObjItem->bSelect = FALSE;
			m_pSelectedItem = NULL;
			strPath = "Can't add the Interaction!!";
		}
	}
	else
	{
		m_pSelectedItem = NULL;
		strPath = "Can't find Object!!";
	}

	//Xe[^Xo[ɕ\
	g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_PATH),strPath);

	InvalidateRect(NULL);
}

/////////////////////////////////////////////////////////////////////////////
// CIBView NX̕`

void CIBView::OnDraw(CDC* pDC)
{
	CIBDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B
/*	if(pDoc == NULL)
	{
		bWViewSChange = FALSE;
		return;
	}
	if(bWViewSChange)
	{
		CChildFrame *pChildFrm = (CChildFrame*)GetParentFrame();
		CIBPreView *pView = (CIBPreView*)pChildFrm->m_tabWnd.getTabView(ID_TAB_PRE);
		LPDISPATCH pDisp = pView->GetHtmlDocument();
		if(pDisp == NULL || !pView->bDLComp)
			return;
		TRACE("ēx͂܂傤\n");
		AnalyzeHTML(pView->GetHtmlDocument());
		bWViewSChange = FALSE;
	}
	TRACE("ĕ`悵܂傤\n");
	CObjItem *pObjItem;
	for(int i=0; i<nObjIndex; i++)
	{
		pObjItem = m_ObjList.GetItem(i);
		CRect rect;
		pObjItem->GetRect(&rect);
		int nType = 0;
		nType = pObjItem->GetObjType();
		
		//eLXg̕\
		if(nType == IDW_OBJ_TEXT)
		{
			CTextObj *pTextObj = (CTextObj*)pObjItem;
		
			CFont *oldFont, newFont;
			newFont.CreatePointFont(pTextObj->m_Font.nPoint*10,pTextObj->m_Font.strFontType);
			LOGFONT logFont;
			newFont.GetLogFont(&logFont);
			newFont.DeleteObject();
			if(pTextObj->m_Font.bItalic)
				logFont.lfItalic = TRUE;
			if(pTextObj->m_Font.bBold)
				logFont.lfWeight = FW_BOLD;
			newFont.CreateFontIndirect(&logFont);
			oldFont = pDC->SelectObject(&newFont);
			pDC->SetTextColor(pTextObj->m_Font.textColor);

			UINT nFormat = DT_WORDBREAK;
			if(pTextObj->m_Font.eAlign == LEFT)
				nFormat |= DT_LEFT;
			else if(pTextObj->m_Font.eAlign == CENTER)
				nFormat |= DT_CENTER;
			else if(pTextObj->m_Font.eAlign == RIGHT)
				nFormat |= DT_RIGHT;

			//wi`𖳂ɂ
			pDC->SetBkMode(TRANSPARENT);
//			pDC->DrawText(pTextObj->strText,rect,DT_LEFT | DT_WORDBREAK | DT_CALCRECT);
			pDC->DrawText(pTextObj->strText,rect,nFormat);

			TRACE("TEXT::%s[%d,%d]\n",pTextObj->strText,rect.left,rect.top);

			newFont.DeleteObject();
			pDC->SelectObject(oldFont);
			pDC->SetBkMode(OPAQUE);
		}
		//摜̕\
		else if(nType == IDW_OBJ_IMG)
		{
			CImgObj *pImgObj = (CImgObj*)pObjItem;

			CRect imgrect;
			pImgObj->GetRect(imgrect);
			TRACE("IMG::[%d,%d]\n",imgrect.left,imgrect.top);
			if(pImgObj->IsValid())
				pImgObj->RenderImage(pDC->m_hDC);
			else  //摜݂Ȃꍇ͉bmp\
			{
				CDC notFoundDC;
				CBitmap nfBMP;
				nfBMP.LoadBitmap(IDB_NOTFOUND);
				notFoundDC.CreateCompatibleDC(pDC);
				CBitmap *oldBMP = notFoundDC.SelectObject(&nfBMP);

				pDC->DrawEdge(&rect,EDGE_BUMP,BF_RECT);

				pDC->BitBlt(rect.left+4,rect.top+4,16,16,&notFoundDC,0,0,SRCCOPY);
				
				notFoundDC.SelectObject(oldBMP);
			}
		}
		else if(nType == IDW_OBJ_TABLE)
		{
			CTableObj *pTableObj = (CTableObj*)pObjItem;

			CRect tableRect;
			pTableObj->GetRect(&tableRect);

			TRACE("TABLE::(%x)[%d,%d]\n",pTableObj->m_ObjStyle.bgcolor,tableRect.left,tableRect.top);
			CBrush *oldBrush,tableBrush;
			tableBrush.CreateSolidBrush(pTableObj->m_ObjStyle.bgcolor);
			oldBrush = pDC->SelectObject(&tableBrush);

			pDC->Rectangle(&tableRect);

			pDC->SelectObject(oldBrush);
			tableBrush.DeleteObject();
		}
		else if(nType == IDW_OBJ_EDIT)
		{
			CTextEditObj *pTextEditObj = (CTextEditObj*)pObjItem;
		}
		else if(nType == IDW_OBJ_BUTTON)
		{
			CButtonObj *pButtonObj = (CButtonObj*)pObjItem;
			if(pObjItem->bSelect)
				pButtonObj->SetSelect();
			else
				pButtonObj->SetRelease();
		}
		if(pObjItem->bSelect && nType != IDW_OBJ_BUTTON)
		{
			CRect SelectRect;
			pObjItem->GetRect(&SelectRect);
			pDC->InvertRect(SelectRect);
		}
	}
	/*
	if(m_pSelectedItem)
	{
		if(m_pSelectedItem->GetObjType() == IDW_OBJ_BUTTON)
		{
			CButtonObj *pButtonObj = (CButtonObj*)m_pSelectedItem;
			pButtonObj->SetSelect();
		}
		else
		{
			CRect SelectRect;
			m_pSelectedItem->GetRect(&SelectRect);
			pDC->InvertRect(SelectRect);
		}
	}
	*/
//	m_pSelectedItem = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// CIBView NẌ

BOOL CIBView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ftHg̈
	return DoPreparePrinting(pInfo);
}

void CIBView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: O̓ʂȏǉĂB
}

void CIBView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: ̌㏈ǉĂB
}

/////////////////////////////////////////////////////////////////////////////
// CIBView NX̐ff

#ifdef _DEBUG
void CIBView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CIBView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CIBDoc* CIBView::GetDocument() // fobO o[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CIBDoc)));
	return (CIBDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CIBView NX̃bZ[W nh

void CIBView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	CSize viewSize(nviewSizeX+100,nviewSizeY+100);
	TRACE("r[TCYύX[%d,%d]\n",nviewSizeX,nviewSizeY);
	SetScrollSizes(MM_TEXT,viewSize);
}

void CIBView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(bActivate)
		bWViewActive = TRUE;
	else
		bWViewActive = FALSE;

	TRACE("[%d]OnActivateView!!!!!!\n",bWViewActive);
	CScrollView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}


void CIBView::OnSize(UINT nType, int cx, int cy) 
{
	CScrollView::OnSize(nType, cx, cy);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	bWViewSChange = TRUE;
}

void CIBView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	TRACE("DblClk\n");
	CObjItem *pObjItem = NULL;
	CPoint scPoint = GetScrollPosition();
	point += scPoint;
	CString strXMLPath = "    ";

	//IuWFNg݂邩H
	FindObjItem(point,&pObjItem);

	//IuWFNgIԂ
	SetSelectedItem(pObjItem,TRUE);

	CScrollView::OnLButtonDblClk(nFlags, point);
}


void CIBView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	TRACE("Down\n");
	CObjItem *pObjItem = NULL;
	CPoint scPoint = GetScrollPosition();
	point += scPoint;

	FindObjItem(point,&pObjItem);

	//IuWFNgIԂ
	SetSelectedItem(pObjItem);
	CScrollView::OnLButtonDown(nFlags, point);
}
